<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.ProjectFilter" Theme="Voxco"
    Trace="false" Async="true" Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="ProjectFilter.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">       
    
    <asp:ObjectDataSource ID="SelectedFiltersDataSource" runat="server" SelectMethod="GetGenericSelected" TypeName="Voxco.Reporting.DataSource.FilterDS">
    </asp:ObjectDataSource>
                
    <asp:ObjectDataSource ID="AvailableFiltersDataSource" runat="server" SelectMethod="GetGenericAvailable" TypeName="Voxco.Reporting.DataSource.FilterDS">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25">
		<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
    </telerik:RadAjaxLoadingPanel>
                
    <telerik:RadAjaxPanel ID="MainAjaxPanel" runat="server" Height="350px" EnableAJAX="true" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="MainAjaxPanel_OnAjaxRequest">
        
        <div style="float:left; width: 45%; height:100%;">				
            <br />
			<asp:Label ID="TitleAvailableFilter" runat="server" Text="<%$ Resources:Resource, AvailableFilters%>" CssClass="title"></asp:Label>
			
            <telerik:RadGrid ID="AvailableProjectFiltersGrid" runat="server" DataSourceID="AvailableFiltersDataSource" 
            GridLines="None" AllowMultiRowSelection="True" AutoGenerateColumns="False" OnItemCreated="ProjectFiltersGrid_OnItemCreated"
            EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
				<ClientSettings>
					<Selecting AllowRowSelect="True" />
					<Scrolling AllowScroll="True" UseStaticHeaders="True" />
				</ClientSettings>
				<MasterTableView DataSourceID="AvailableFiltersDataSource" NoMasterRecordsText="" Width="100%">
					<SortExpressions>
						<telerik:GridSortExpression FieldName="FilterTitle" />
					</SortExpressions>
					<Columns>
						<telerik:GridBoundColumn DataField="FilterID" DataType="System.Int32" Display="False" HeaderText="FilterID" UniqueName="FilterID">
						</telerik:GridBoundColumn>
						<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
							<HeaderStyle Width="10%" HorizontalAlign="Left" />
							<ItemStyle Width="10%" HorizontalAlign="Left" />
						</telerik:GridClientSelectColumn>
						<telerik:GridBoundColumn DataField="FilterTitle" HeaderText="<%$ Resources:Resource, AvailableFilters%>" UniqueName="FilterTitle">
							<HeaderStyle Width="35%" HorizontalAlign="left" />
							<ItemStyle Width="35%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="ProjectID" DataType="System.Int32" HeaderText="ProjectID" Display="False" UniqueName="ProjectID" >
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="ProjectName" HeaderText="<%$ Resources:Resource, Project%>" UniqueName="ProjectName">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="FullPath" HeaderText="<%$ Resources:Resource, Path %>" UniqueName="FullPath">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="DataXML" HeaderText="DataXML" UniqueName="DataXML" Display="false" >
						</telerik:GridBoundColumn>
					</Columns>                           
				</MasterTableView>                        
			</telerik:RadGrid>

		</div>
			
		<div style="float:left; height:100%; width: 25px;">
		
			<asp:Panel ID="ButtonSelectionPane" Width="25px" Height="100%" runat="server">
				<div class="arrows">
					<asp:ImageButton ID="btnAddProjectFilter" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddProjectFilter_OnClick" style="margin-bottom: 20px;" />
					<asp:ImageButton ID="btnRemoveProjectFilter" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveProjectFilter_OnClick" />
				</div>
			</asp:Panel>             
			
		</div>
			
		<div style="float: left; width: 45%; height:100%;">
				
			<br />
			<asp:Label ID="TitleSelectedFilter" runat="server" Text="<%$ Resources:Resource, SelectedFilters%>" CssClass="title"></asp:Label>
                    
            <telerik:RadGrid ID="SelectedProjectFiltersGrid" runat="server" DataSourceID="SelectedFiltersDataSource" AllowMultiRowSelection="True"
            AutoGenerateColumns="False" OnItemCreated="ProjectFiltersGrid_OnItemCreated" OnDataBound="SelectedProjectFiltersGrid_OnDataBound"
            EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
				<ClientSettings>
					<Selecting AllowRowSelect="True" />
					<Scrolling AllowScroll="True" UseStaticHeaders="True" />
				</ClientSettings>
				<MasterTableView DataSourceID="SelectedFiltersDataSource" NoMasterRecordsText="" Width="100%">
					<SortExpressions>
						<telerik:GridSortExpression FieldName="FilterTitle" />
					</SortExpressions>
					<Columns>
						<telerik:GridBoundColumn DataField="FilterID" DataType="System.Int32" Display="False" HeaderText="FilterID" UniqueName="FilterID">
						</telerik:GridBoundColumn>
						<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
							<HeaderStyle Width="10%" HorizontalAlign="left" />
							<ItemStyle Width="10%" HorizontalAlign="left" />
						</telerik:GridClientSelectColumn>
						<telerik:GridBoundColumn DataField="FilterTitle" HeaderText="<%$ Resources:Resource, SelectedFilters%>" UniqueName="FilterTitle">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="ProjectID" DataType="System.Int32" HeaderText="ProjectID" Display="False" UniqueName="ProjectID">
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="ProjectName" HeaderText="<%$ Resources:Resource, Project%>" UniqueName="ProjectName">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="FullPath" HeaderText="<%$ Resources:Resource, Path %>" UniqueName="FullPath">
							<HeaderStyle Width="30%" HorizontalAlign="left" />
							<ItemStyle Width="30%" HorizontalAlign="left" />
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="DataXML" HeaderText="DataXML" UniqueName="DataXML" Display="false" >
						</telerik:GridBoundColumn>
						<telerik:GridBoundColumn DataField="Invalid" UniqueName="Invalid" Display="false" >
						</telerik:GridBoundColumn>
					</Columns>
				</MasterTableView>
			</telerik:RadGrid>
            
		</div>
	
	</telerik:RadAjaxPanel>

</asp:Content>

